/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ceutils;

import com.filenet.api.admin.IsolatedRegion;
import com.filenet.api.admin.PEConnectionPoint;
import com.filenet.api.collection.PEConnectionPointSet;
import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.util.J2EEUtil;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.peorb.client.UserPasswordCallbackHandler;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class CEAPITest
implements PrivilegedExceptionAction {
    private static PropertyFilter IT_PF = null;
    private static String JAAS_Selector;
    private Subject m_subject = null;
    private Domain m_localDomain = null;
    private String m_ceURI = null;
    private String m_username = null;
    private boolean verbose = true;
    private boolean doPE = true;

    private static void msg(String s) {
        System.out.println(s);
    }

    private static void error(String s) {
        System.err.println(s);
    }

    private static void printSubject(Subject subj) {
        try {
            Set<Principal> p = subj.getPrincipals();
            if (p == null || p.isEmpty()) {
                CEAPITest.msg(" has no Principals yet...");
            } else {
                Principal pp = (Principal)subj.getPrincipals().toArray()[0];
                String username = pp.getName();
                CEAPITest.msg("principal=" + pp + ", username = " + username);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CEAPITest() {
    }

    public CEAPITest(String name, String pw, String ceURI, boolean verbose, boolean doPE) throws Exception {
        this.doPE = doPE;
        this.verbose = verbose;
        UserPasswordCallbackHandler cbh = new UserPasswordCallbackHandler(name, pw.toCharArray(), ceURI);
        LoginContext lc = new LoginContext(JAAS_Selector, cbh);
        lc.login();
        this.m_subject = lc.getSubject();
        if (verbose) {
            CEAPITest.printSubject(this.m_subject);
        }
        this.m_ceURI = ceURI;
        this.m_username = name;
    }

    public Object run() {
        try {
            Domain m_localDomain;
            EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)Factory.Connection.getConnection((String)this.m_ceURI), null);
            if (this.verbose) {
                CEAPITest.msg("Getting Domain object via Factory.EntireNetwork.get_LocalDomain");
            }
            if ((m_localDomain = entireNetwork.get_LocalDomain()) == null) {
                CEAPITest.error("NULL DOMAIN!!");
                return null;
            }
            PEConnectionPointSet set = m_localDomain.get_PEConnectionPoints();
            int nCPs = ((AbstractEngineSet)set).getList().size();
            if (this.verbose) {
                CEAPITest.msg("Found " + nCPs + " connection points");
            }
            if (nCPs == 0) {
                return null;
            }
            Iterator iter = set.iterator();
            Object res = null;
            boolean i = false;
            while (iter.hasNext()) {
                PEConnectionPoint p = (PEConnectionPoint)iter.next();
                IsolatedRegion ir = p.get_IsolatedRegion();
                if (!this.verbose) continue;
                CEAPITest.msg("Connection Point = " + p.get_Name() + ", Isolated Region=" + ir.get_DNSName() + ":" + ir.get_BrokerPort() + ", " + ir.get_IsolatedRegionNumber());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void getConnectionPoints2() {
        if (this.verbose) {
            CEAPITest.msg("===============================================");
            CEAPITest.msg("getConnectionPoints2 for " + this.m_username + ", " + this.m_ceURI);
            CEAPITest.printSubject(this.m_subject);
        }
        J2EEUtil.getInstance().doAs(this.m_subject, (PrivilegedExceptionAction)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnectionPoints() {
        if (this.verbose) {
            CEAPITest.msg("===============================================");
            CEAPITest.msg("getConnectionPoints for " + this.m_username + ", " + this.m_ceURI);
            CEAPITest.printSubject(this.m_subject);
        }
        if (this.m_subject == null) {
            return;
        }
        UserContext old = UserContext.get();
        try {
            UserContext uc = new UserContext();
            UserContext.set((UserContext)uc);
            uc.pushSubject(this.m_subject);
            Connection conn = Factory.Connection.getConnection((String)this.m_ceURI);
            if (conn != null) {
                if (this.verbose) {
                    CEAPITest.msg("Getting Domain object via Factory.Domain.fetchInstance");
                }
                this.m_localDomain = Factory.Domain.fetchInstance((Connection)conn, null, null);
            }
            PEConnectionPointSet set = this.m_localDomain.get_PEConnectionPoints();
            int nCPs = ((AbstractEngineSet)set).getList().size();
            if (this.verbose) {
                CEAPITest.msg("Found " + nCPs + " connection points");
            }
            if (nCPs == 0) {
                return;
            }
            Iterator iter = set.iterator();
            Object res = null;
            boolean i = false;
            while (iter.hasNext()) {
                PEConnectionPoint p = (PEConnectionPoint)iter.next();
                IsolatedRegion ir = p.get_IsolatedRegion();
                if (this.verbose) {
                    CEAPITest.msg("Connection Point = " + p.get_Name() + ", Isolated Region=" + ir.get_DNSName() + ":" + ir.get_BrokerPort() + ", " + ir.get_IsolatedRegionNumber());
                }
                if (!this.doPE) continue;
                ConnectionPoint p2 = new ConnectionPoint(p.get_Name(), ir.get_DNSName(), ir.get_BrokerPort(), ir.get_IsolatedRegionNumber(), this.m_ceURI);
                ir.refresh(IT_PF);
                try {
                    p2.IdentityToken = ir.getProperties().getBinaryValue("IdentityToken");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            UserContext.set((UserContext)old);
        }
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h") || c.isPresent("?")) {
                System.out.println("[/ceURI <ceURI>] [/name <name>] [/pw <pw] [/n ##] [/verbose] [/pe]");
                System.out.println("Default ceURI=http://hqruby:7011/wsi/FNCEWS40DIME");
                System.out.println("Default name=PEAdmin");
                System.out.println("Default pw=Wxxxxxxx");
                System.out.println("Default n=100");
                System.out.println("/verbose to be more info");
                System.out.println("/pe to turn on the instantiating of Connection point and retrieving the identity token.");
            }
            String ceURI = c.getParameter("ceURI", "http://hqruby:7011/wsi/FNCEWS40DIME");
            String pw = c.getParameter("pw", "WFQA20zz");
            String name = c.getParameter("name", "PEAdmin");
            int ntimes = c.getIntParameter("n", 100);
            if (ntimes == 0) {
                ntimes = 100;
            }
            boolean verbose = c.isPresent("v") || c.isPresent("verbose");
            boolean doPE = c.isPresent("pe");
            Timer t = new Timer("FIRST ATTEMPT.");
            CEAPITest test1 = new CEAPITest(name, pw, ceURI, verbose, doPE);
            test1.getConnectionPoints();
            t.stop();
            if (--ntimes == 0) {
                System.exit(0);
            }
            t.start("Next " + ntimes + " times...");
            for (int i = 0; i < ntimes; ++i) {
                test1 = new CEAPITest(name, pw, ceURI, verbose, doPE);
                test1.getConnectionPoints();
            }
            long elapsed = t.stop();
            double average = elapsed / (long)ntimes;
            CEAPITest.msg("Average=" + average);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        IT_PF = new PropertyFilter();
        IT_PF.addIncludeProperty(0, null, null, "IdentityToken");
        JAAS_Selector = "FileNetP8";
    }

    static class Timer {
        long begin;
        String m_loc;

        public void start(String s) {
            this.m_loc = s;
            this.begin = System.currentTimeMillis();
        }

        public Timer(String s) {
            this.start(s);
        }

        public long stop() {
            long elapsed = System.currentTimeMillis() - this.begin;
            System.out.println(this.m_loc + " took " + elapsed + " ms.");
            return elapsed;
        }
    }
}

